/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IHandState;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.client.animation.AimAnimation;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.setup.AbstractGun;
import dev.toma.gunsrpg.common.item.guns.util.Firemode;
import dev.toma.gunsrpg.common.item.guns.util.InputEventListenerType;
import dev.toma.gunsrpg.common.item.guns.util.ScopeDataRegistry;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_SetAimingPacket;
import dev.toma.gunsrpg.sided.ClientSideManager;
import dev.toma.gunsrpg.util.object.PropertyChangeListener;
import dev.toma.gunsrpg.util.object.ShootingManager;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.api.IAnimationPipeline;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="gunsrpg")
public class ClientEventHandler {
    private static final PropertyChangeListener<Boolean, PlayerEntity> startSprintListener = new PropertyChangeListener<Boolean, PlayerEntity>(Entity::func_70051_ag, ClientEventHandler::dispatchSprintAnimation);
    public static float partialTicks;
    public static boolean bloodmoon;

    @SubscribeEvent
    public static void cancelHandSwinging(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && player.func_184614_ca().func_77973_b() instanceof AbstractGun) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void mouseInputEvent(InputEvent.MouseInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        GameSettings settings = mc.field_71474_y;
        if (player != null) {
            GunItem item = ShootingManager.getGunFrom((PlayerEntity)player);
            ItemStack stack = player.func_184614_ca();
            AnimationEngine engine = AnimationEngine.get();
            IAnimationPipeline pipeline = engine.pipeline();
            LazyOptional<IPlayerData> optional = PlayerData.get((PlayerEntity)player);
            if (item != null) {
                if (settings.field_74312_F.func_151470_d()) {
                    Firemode firemode = item.getFiremode(stack);
                    InputEventListenerType inputEvent = InputEventListenerType.ON_INPUT;
                    optional.ifPresent(arg_0 -> ClientEventHandler.lambda$mouseInputEvent$0(firemode, inputEvent, (PlayerEntity)player, stack, arg_0));
                    if (!item.hasAmmo(stack)) {
                        player.func_184185_a(ModSounds.EMPTY_GUN_CLICK, 1.0f, 1.0f);
                    }
                } else if (settings.field_74313_G.func_151470_d() && !AnimationUtils.isActiveOrScheduled(pipeline, ModAnimations.CHAMBER) && !player.func_70051_ag()) {
                    optional.ifPresent(arg_0 -> ClientEventHandler.lambda$mouseInputEvent$1(optional, settings, (PlayerEntity)player, item, stack, pipeline, arg_0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.getHand() == Hand.OFF_HAND && event.getItemStack().func_77973_b() instanceof ShieldItem && player.func_184614_ca().func_77973_b() instanceof GunItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (event.phase == TickEvent.Phase.END && player != null) {
            ItemStack stack;
            LazyOptional<IPlayerData> optional = PlayerData.get((PlayerEntity)player);
            ClientEventHandler.updateCurrentBloodmoonStatus((PlayerEntity)player);
            if (!optional.isPresent()) {
                return;
            }
            IPlayerData data = (IPlayerData)optional.orElse(null);
            ShootingManager.tickShootingDelay();
            startSprintListener.refresh((PlayerEntity)player);
            GameSettings settings = mc.field_71474_y;
            if (settings.field_74312_F.func_151470_d()) {
                ClientEventHandler.dispatchWeaponInputEvent(InputEventListenerType.ON_TICK, (PlayerEntity)player, data);
            }
            if (ShootingManager.Client.isBurstModeActive()) {
                ClientEventHandler.dispatchWeaponInputEvent(InputEventListenerType.ON_BURST_TICK, (PlayerEntity)player, data);
            }
            if ((stack = player.func_184614_ca()).func_77973_b() instanceof GunItem) {
                GunItem gun = (GunItem)stack.func_77973_b();
                if (data.getAimInfo().isAiming() && ClientSideManager.config.aimInputType.isHold() && !settings.field_74313_G.func_151470_d()) {
                    IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
                    ClientEventHandler.handleAim(optional, settings, (PlayerEntity)player, gun, stack, pipeline);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        partialTicks = event.renderTickTime;
    }

    @SubscribeEvent
    public static void onSetFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (bloodmoon) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            long dayTime = world.func_72820_D() % 24000L;
            float diff = 1.0f;
            if (dayTime < 14000L) {
                diff = (float)(dayTime - 12500L) / 1500.0f;
            }
            if (dayTime > 22500L) {
                diff = 1.0f - (float)(dayTime - 22500L) / 1500.0f;
            }
            float baseFog = 0.003f;
            float fog = (0.03f - baseFog) * diff;
            event.setDensity(baseFog + fog);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSetFogColor(EntityViewRenderEvent.FogColors event) {
        if (!bloodmoon) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        long dayTime = world.func_72820_D() % 24000L;
        float diff = 1.0f;
        if (dayTime < 14000L) {
            diff = (float)(dayTime - 12500L) / 1500.0f;
        }
        if (dayTime > 22500L) {
            diff = 1.0f - (float)(dayTime - 22500L) / 1500.0f;
        }
        float r = event.getRed();
        float g = event.getGreen();
        float b = event.getBlue();
        float r1 = 1.0f - r;
        float idiff = 1.0f - diff;
        event.setRed(r + r1 * diff * 0.4f);
        event.setGreen(g * idiff);
        event.setBlue(b * idiff);
    }

    private static void handleAim(LazyOptional<IPlayerData> optional, GameSettings settings, PlayerEntity player, GunItem item, ItemStack stack, IAnimationPipeline pipeline) {
        boolean aim;
        boolean bl = aim = optional.isPresent() && ((IPlayerData)optional.orElse(null)).getAimInfo().startedAiming();
        if (!aim) {
            ShootingManager.Client.saveSettings(settings);
            ScopeDataRegistry.Entry entry = ScopeDataRegistry.getRegistry().getRegistryEntry(item);
            optional.ifPresent(data -> {
                ISkillProvider provider = data.getSkillProvider();
                if (entry.isApplicable(provider)) {
                    ShootingManager.Client.applySettings(settings, entry);
                }
            });
            ResourceLocation aimAnimationPath = item.getAimAnimationPath(stack, player);
            if (aimAnimationPath != null) {
                pipeline.insert(ModAnimations.AIM_ANIMATION, AnimationUtils.createAnimation(aimAnimationPath, AimAnimation::new));
            }
        } else {
            ShootingManager.Client.loadSettings(settings);
        }
        NetworkManager.sendServerPacket(new C2S_SetAimingPacket(!aim));
    }

    private static void dispatchSprintAnimation(boolean isSprinting, PlayerEntity player) {
        if (!isSprinting) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        LazyOptional<IPlayerData> optional = PlayerData.get(player);
        optional.ifPresent(data -> {
            IHandState handState = data.getHandState();
            if (stack.func_77973_b() instanceof GunItem && !handState.areHandsBusy()) {
                IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
                pipeline.insert(ModAnimations.SPRINT);
            }
        });
    }

    private static void dispatchWeaponInputEvent(InputEventListenerType event, PlayerEntity player, IPlayerData data) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof GunItem) {
            GunItem item = (GunItem)stack.func_77973_b();
            Firemode firemode = item.getFiremode(stack);
            firemode.triggerEvent(event, player, stack, data);
        }
    }

    private static void updateCurrentBloodmoonStatus(PlayerEntity player) {
        World world = player.field_70170_p;
        long actualDay = world.func_72820_D() / 24000L;
        int cycle = GunsRPG.config.world.bloodmoonCycle;
        if (cycle == -1) {
            return;
        }
        boolean isBloodmoonDay = actualDay > 0L && (cycle == 0 || actualDay % (long)cycle == 0L);
        boolean isNight = world.func_72820_D() % 24000L >= 12500L;
        bloodmoon = isBloodmoonDay && isNight;
    }

    private static /* synthetic */ void lambda$mouseInputEvent$1(LazyOptional optional, GameSettings settings, PlayerEntity player, GunItem item, ItemStack stack, IAnimationPipeline pipeline, IPlayerData data) {
        if (!data.getAimInfo().isAiming() || !ClientSideManager.config.aimInputType.isHold()) {
            ClientEventHandler.handleAim((LazyOptional<IPlayerData>)optional, settings, player, item, stack, pipeline);
        }
    }

    private static /* synthetic */ void lambda$mouseInputEvent$0(Firemode firemode, InputEventListenerType inputEvent, PlayerEntity player, ItemStack stack, IPlayerData data) {
        firemode.triggerEvent(inputEvent, player, stack, data);
    }
}

